﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>The detailed data about the current state of the environment.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/EnvironmentState">AWS
 * API Reference</a></p>
 */
class EnvironmentState {
 public:
  AWS_PROTON_API EnvironmentState() = default;
  AWS_PROTON_API EnvironmentState(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API EnvironmentState& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The environment spec that was used to create the environment.</p>
   */
  inline const Aws::String& GetSpec() const { return m_spec; }
  inline bool SpecHasBeenSet() const { return m_specHasBeenSet; }
  template <typename SpecT = Aws::String>
  void SetSpec(SpecT&& value) {
    m_specHasBeenSet = true;
    m_spec = std::forward<SpecT>(value);
  }
  template <typename SpecT = Aws::String>
  EnvironmentState& WithSpec(SpecT&& value) {
    SetSpec(std::forward<SpecT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The major version of the environment template that was used to create the
   * environment.</p>
   */
  inline const Aws::String& GetTemplateMajorVersion() const { return m_templateMajorVersion; }
  inline bool TemplateMajorVersionHasBeenSet() const { return m_templateMajorVersionHasBeenSet; }
  template <typename TemplateMajorVersionT = Aws::String>
  void SetTemplateMajorVersion(TemplateMajorVersionT&& value) {
    m_templateMajorVersionHasBeenSet = true;
    m_templateMajorVersion = std::forward<TemplateMajorVersionT>(value);
  }
  template <typename TemplateMajorVersionT = Aws::String>
  EnvironmentState& WithTemplateMajorVersion(TemplateMajorVersionT&& value) {
    SetTemplateMajorVersion(std::forward<TemplateMajorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minor version of the environment template that was used to create the
   * environment.</p>
   */
  inline const Aws::String& GetTemplateMinorVersion() const { return m_templateMinorVersion; }
  inline bool TemplateMinorVersionHasBeenSet() const { return m_templateMinorVersionHasBeenSet; }
  template <typename TemplateMinorVersionT = Aws::String>
  void SetTemplateMinorVersion(TemplateMinorVersionT&& value) {
    m_templateMinorVersionHasBeenSet = true;
    m_templateMinorVersion = std::forward<TemplateMinorVersionT>(value);
  }
  template <typename TemplateMinorVersionT = Aws::String>
  EnvironmentState& WithTemplateMinorVersion(TemplateMinorVersionT&& value) {
    SetTemplateMinorVersion(std::forward<TemplateMinorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the environment template that was used to create the
   * environment.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  EnvironmentState& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_spec;

  Aws::String m_templateMajorVersion;

  Aws::String m_templateMinorVersion;

  Aws::String m_templateName;
  bool m_specHasBeenSet = false;
  bool m_templateMajorVersionHasBeenSet = false;
  bool m_templateMinorVersionHasBeenSet = false;
  bool m_templateNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
