﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>Compatible environment template data.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CompatibleEnvironmentTemplate">AWS
 * API Reference</a></p>
 */
class CompatibleEnvironmentTemplate {
 public:
  AWS_PROTON_API CompatibleEnvironmentTemplate() = default;
  AWS_PROTON_API CompatibleEnvironmentTemplate(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API CompatibleEnvironmentTemplate& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The major version of the compatible environment template.</p>
   */
  inline const Aws::String& GetMajorVersion() const { return m_majorVersion; }
  inline bool MajorVersionHasBeenSet() const { return m_majorVersionHasBeenSet; }
  template <typename MajorVersionT = Aws::String>
  void SetMajorVersion(MajorVersionT&& value) {
    m_majorVersionHasBeenSet = true;
    m_majorVersion = std::forward<MajorVersionT>(value);
  }
  template <typename MajorVersionT = Aws::String>
  CompatibleEnvironmentTemplate& WithMajorVersion(MajorVersionT&& value) {
    SetMajorVersion(std::forward<MajorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The compatible environment template name.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  CompatibleEnvironmentTemplate& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_majorVersion;

  Aws::String m_templateName;
  bool m_majorVersionHasBeenSet = false;
  bool m_templateNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
