﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/neptune/Neptune_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Neptune {
namespace Model {

/**
 * <p>Specifies membership in a designated DB security group.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/neptune-2014-10-31/DBSecurityGroupMembership">AWS
 * API Reference</a></p>
 */
class DBSecurityGroupMembership {
 public:
  AWS_NEPTUNE_API DBSecurityGroupMembership() = default;
  AWS_NEPTUNE_API DBSecurityGroupMembership(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_NEPTUNE_API DBSecurityGroupMembership& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_NEPTUNE_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_NEPTUNE_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the DB security group.</p>
   */
  inline const Aws::String& GetDBSecurityGroupName() const { return m_dBSecurityGroupName; }
  inline bool DBSecurityGroupNameHasBeenSet() const { return m_dBSecurityGroupNameHasBeenSet; }
  template <typename DBSecurityGroupNameT = Aws::String>
  void SetDBSecurityGroupName(DBSecurityGroupNameT&& value) {
    m_dBSecurityGroupNameHasBeenSet = true;
    m_dBSecurityGroupName = std::forward<DBSecurityGroupNameT>(value);
  }
  template <typename DBSecurityGroupNameT = Aws::String>
  DBSecurityGroupMembership& WithDBSecurityGroupName(DBSecurityGroupNameT&& value) {
    SetDBSecurityGroupName(std::forward<DBSecurityGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the DB security group.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  DBSecurityGroupMembership& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_dBSecurityGroupName;

  Aws::String m_status;
  bool m_dBSecurityGroupNameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Neptune
}  // namespace Aws
