﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/marketplace-catalog/MarketplaceCatalog_EXPORTS.h>
#include <aws/marketplace-catalog/model/MachineLearningProductLastModifiedDateFilterDateRange.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MarketplaceCatalog {
namespace Model {

/**
 * <p>The filter for machine learning product last modified date.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/MachineLearningProductLastModifiedDateFilter">AWS
 * API Reference</a></p>
 */
class MachineLearningProductLastModifiedDateFilter {
 public:
  AWS_MARKETPLACECATALOG_API MachineLearningProductLastModifiedDateFilter() = default;
  AWS_MARKETPLACECATALOG_API MachineLearningProductLastModifiedDateFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_MARKETPLACECATALOG_API MachineLearningProductLastModifiedDateFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MARKETPLACECATALOG_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A date range to filter by. The operation returns machine learning products
   * with last modified dates that fall within this range.</p>
   */
  inline const MachineLearningProductLastModifiedDateFilterDateRange& GetDateRange() const { return m_dateRange; }
  inline bool DateRangeHasBeenSet() const { return m_dateRangeHasBeenSet; }
  template <typename DateRangeT = MachineLearningProductLastModifiedDateFilterDateRange>
  void SetDateRange(DateRangeT&& value) {
    m_dateRangeHasBeenSet = true;
    m_dateRange = std::forward<DateRangeT>(value);
  }
  template <typename DateRangeT = MachineLearningProductLastModifiedDateFilterDateRange>
  MachineLearningProductLastModifiedDateFilter& WithDateRange(DateRangeT&& value) {
    SetDateRange(std::forward<DateRangeT>(value));
    return *this;
  }
  ///@}
 private:
  MachineLearningProductLastModifiedDateFilterDateRange m_dateRange;
  bool m_dateRangeHasBeenSet = false;
};

}  // namespace Model
}  // namespace MarketplaceCatalog
}  // namespace Aws
