﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/macie2/Macie2_EXPORTS.h>
#include <aws/macie2/model/AllowListSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Macie2 {
namespace Model {
class ListAllowListsResult {
 public:
  AWS_MACIE2_API ListAllowListsResult() = default;
  AWS_MACIE2_API ListAllowListsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MACIE2_API ListAllowListsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects, one for each allow list.</p>
   */
  inline const Aws::Vector<AllowListSummary>& GetAllowLists() const { return m_allowLists; }
  template <typename AllowListsT = Aws::Vector<AllowListSummary>>
  void SetAllowLists(AllowListsT&& value) {
    m_allowListsHasBeenSet = true;
    m_allowLists = std::forward<AllowListsT>(value);
  }
  template <typename AllowListsT = Aws::Vector<AllowListSummary>>
  ListAllowListsResult& WithAllowLists(AllowListsT&& value) {
    SetAllowLists(std::forward<AllowListsT>(value));
    return *this;
  }
  template <typename AllowListsT = AllowListSummary>
  ListAllowListsResult& AddAllowLists(AllowListsT&& value) {
    m_allowListsHasBeenSet = true;
    m_allowLists.emplace_back(std::forward<AllowListsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The string to use in a subsequent request to get the next page of results in
   * a paginated response. This value is null if there are no additional pages.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAllowListsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAllowListsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AllowListSummary> m_allowLists;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_allowListsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
