﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafka/KafkaRequest.h>
#include <aws/kafka/Kafka_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Kafka {
namespace Model {

/**
 */
class DeleteReplicatorRequest : public KafkaRequest {
 public:
  AWS_KAFKA_API DeleteReplicatorRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteReplicator"; }

  AWS_KAFKA_API Aws::String SerializePayload() const override;

  AWS_KAFKA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The current version of the replicator.</p>
   */
  inline const Aws::String& GetCurrentVersion() const { return m_currentVersion; }
  inline bool CurrentVersionHasBeenSet() const { return m_currentVersionHasBeenSet; }
  template <typename CurrentVersionT = Aws::String>
  void SetCurrentVersion(CurrentVersionT&& value) {
    m_currentVersionHasBeenSet = true;
    m_currentVersion = std::forward<CurrentVersionT>(value);
  }
  template <typename CurrentVersionT = Aws::String>
  DeleteReplicatorRequest& WithCurrentVersion(CurrentVersionT&& value) {
    SetCurrentVersion(std::forward<CurrentVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the replicator to be deleted.</p>
   */
  inline const Aws::String& GetReplicatorArn() const { return m_replicatorArn; }
  inline bool ReplicatorArnHasBeenSet() const { return m_replicatorArnHasBeenSet; }
  template <typename ReplicatorArnT = Aws::String>
  void SetReplicatorArn(ReplicatorArnT&& value) {
    m_replicatorArnHasBeenSet = true;
    m_replicatorArn = std::forward<ReplicatorArnT>(value);
  }
  template <typename ReplicatorArnT = Aws::String>
  DeleteReplicatorRequest& WithReplicatorArn(ReplicatorArnT&& value) {
    SetReplicatorArn(std::forward<ReplicatorArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_currentVersion;

  Aws::String m_replicatorArn;
  bool m_currentVersionHasBeenSet = false;
  bool m_replicatorArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
