﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ivs-realtime/Ivsrealtime_EXPORTS.h>
#include <aws/ivs-realtime/model/IngestConfigurationState.h>
#include <aws/ivs-realtime/model/IngestProtocol.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ivsrealtime {
namespace Model {

/**
 * <p>Summary information about an IngestConfiguration.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/IngestConfigurationSummary">AWS
 * API Reference</a></p>
 */
class IngestConfigurationSummary {
 public:
  AWS_IVSREALTIME_API IngestConfigurationSummary() = default;
  AWS_IVSREALTIME_API IngestConfigurationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IVSREALTIME_API IngestConfigurationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IVSREALTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Ingest name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  IngestConfigurationSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Ingest configuration ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  IngestConfigurationSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Type of ingest protocol that the user employs for broadcasting.</p>
   */
  inline IngestProtocol GetIngestProtocol() const { return m_ingestProtocol; }
  inline bool IngestProtocolHasBeenSet() const { return m_ingestProtocolHasBeenSet; }
  inline void SetIngestProtocol(IngestProtocol value) {
    m_ingestProtocolHasBeenSet = true;
    m_ingestProtocol = value;
  }
  inline IngestConfigurationSummary& WithIngestProtocol(IngestProtocol value) {
    SetIngestProtocol(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ARN of the stage with which the IngestConfiguration is associated.</p>
   */
  inline const Aws::String& GetStageArn() const { return m_stageArn; }
  inline bool StageArnHasBeenSet() const { return m_stageArnHasBeenSet; }
  template <typename StageArnT = Aws::String>
  void SetStageArn(StageArnT&& value) {
    m_stageArnHasBeenSet = true;
    m_stageArn = std::forward<StageArnT>(value);
  }
  template <typename StageArnT = Aws::String>
  IngestConfigurationSummary& WithStageArn(StageArnT&& value) {
    SetStageArn(std::forward<StageArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ID of the participant within the stage.</p>
   */
  inline const Aws::String& GetParticipantId() const { return m_participantId; }
  inline bool ParticipantIdHasBeenSet() const { return m_participantIdHasBeenSet; }
  template <typename ParticipantIdT = Aws::String>
  void SetParticipantId(ParticipantIdT&& value) {
    m_participantIdHasBeenSet = true;
    m_participantId = std::forward<ParticipantIdT>(value);
  }
  template <typename ParticipantIdT = Aws::String>
  IngestConfigurationSummary& WithParticipantId(ParticipantIdT&& value) {
    SetParticipantId(std::forward<ParticipantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>State of the ingest configuration. It is <code>ACTIVE</code> if a publisher
   * currently is publishing to the stage associated with the ingest
   * configuration.</p>
   */
  inline IngestConfigurationState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(IngestConfigurationState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline IngestConfigurationSummary& WithState(IngestConfigurationState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Customer-assigned name to help identify the participant using the
   * IngestConfiguration; this can be used to link a participant to a user in the
   * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is
   * exposed to all stage participants and should not be used for personally
   * identifying, confidential, or sensitive information.</i> </p>
   */
  inline const Aws::String& GetUserId() const { return m_userId; }
  inline bool UserIdHasBeenSet() const { return m_userIdHasBeenSet; }
  template <typename UserIdT = Aws::String>
  void SetUserId(UserIdT&& value) {
    m_userIdHasBeenSet = true;
    m_userId = std::forward<UserIdT>(value);
  }
  template <typename UserIdT = Aws::String>
  IngestConfigurationSummary& WithUserId(UserIdT&& value) {
    SetUserId(std::forward<UserIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_arn;

  IngestProtocol m_ingestProtocol{IngestProtocol::NOT_SET};

  Aws::String m_stageArn;

  Aws::String m_participantId;

  IngestConfigurationState m_state{IngestConfigurationState::NOT_SET};

  Aws::String m_userId;
  bool m_nameHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_ingestProtocolHasBeenSet = false;
  bool m_stageArnHasBeenSet = false;
  bool m_participantIdHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_userIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ivsrealtime
}  // namespace Aws
