﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/inspector2/model/AssociationResultStatusCode.h>
#include <aws/inspector2/model/CodeSecurityResource.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Inspector2 {
namespace Model {

/**
 * <p>Details about a failed attempt to associate or disassociate a code repository
 * with a scan configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/FailedAssociationResult">AWS
 * API Reference</a></p>
 */
class FailedAssociationResult {
 public:
  AWS_INSPECTOR2_API FailedAssociationResult() = default;
  AWS_INSPECTOR2_API FailedAssociationResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR2_API FailedAssociationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the scan configuration that failed to be
   * associated or disassociated.</p>
   */
  inline const Aws::String& GetScanConfigurationArn() const { return m_scanConfigurationArn; }
  inline bool ScanConfigurationArnHasBeenSet() const { return m_scanConfigurationArnHasBeenSet; }
  template <typename ScanConfigurationArnT = Aws::String>
  void SetScanConfigurationArn(ScanConfigurationArnT&& value) {
    m_scanConfigurationArnHasBeenSet = true;
    m_scanConfigurationArn = std::forward<ScanConfigurationArnT>(value);
  }
  template <typename ScanConfigurationArnT = Aws::String>
  FailedAssociationResult& WithScanConfigurationArn(ScanConfigurationArnT&& value) {
    SetScanConfigurationArn(std::forward<ScanConfigurationArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const CodeSecurityResource& GetResource() const { return m_resource; }
  inline bool ResourceHasBeenSet() const { return m_resourceHasBeenSet; }
  template <typename ResourceT = CodeSecurityResource>
  void SetResource(ResourceT&& value) {
    m_resourceHasBeenSet = true;
    m_resource = std::forward<ResourceT>(value);
  }
  template <typename ResourceT = CodeSecurityResource>
  FailedAssociationResult& WithResource(ResourceT&& value) {
    SetResource(std::forward<ResourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status code indicating why the association or disassociation failed.</p>
   */
  inline AssociationResultStatusCode GetStatusCode() const { return m_statusCode; }
  inline bool StatusCodeHasBeenSet() const { return m_statusCodeHasBeenSet; }
  inline void SetStatusCode(AssociationResultStatusCode value) {
    m_statusCodeHasBeenSet = true;
    m_statusCode = value;
  }
  inline FailedAssociationResult& WithStatusCode(AssociationResultStatusCode value) {
    SetStatusCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A message explaining why the association or disassociation failed.</p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  FailedAssociationResult& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scanConfigurationArn;

  CodeSecurityResource m_resource;

  AssociationResultStatusCode m_statusCode{AssociationResultStatusCode::NOT_SET};

  Aws::String m_statusMessage;
  bool m_scanConfigurationArnHasBeenSet = false;
  bool m_resourceHasBeenSet = false;
  bool m_statusCodeHasBeenSet = false;
  bool m_statusMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace Inspector2
}  // namespace Aws
