﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticbeanstalk/ElasticBeanstalk_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace ElasticBeanstalk {
namespace Model {

/**
 * <p>Describes a queue.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/Queue">AWS
 * API Reference</a></p>
 */
class Queue {
 public:
  AWS_ELASTICBEANSTALK_API Queue() = default;
  AWS_ELASTICBEANSTALK_API Queue(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_ELASTICBEANSTALK_API Queue& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_ELASTICBEANSTALK_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index,
                                               const char* locationValue) const;
  AWS_ELASTICBEANSTALK_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the queue.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Queue& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL of the queue.</p>
   */
  inline const Aws::String& GetURL() const { return m_uRL; }
  inline bool URLHasBeenSet() const { return m_uRLHasBeenSet; }
  template <typename URLT = Aws::String>
  void SetURL(URLT&& value) {
    m_uRLHasBeenSet = true;
    m_uRL = std::forward<URLT>(value);
  }
  template <typename URLT = Aws::String>
  Queue& WithURL(URLT&& value) {
    SetURL(std::forward<URLT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_uRL;
  bool m_nameHasBeenSet = false;
  bool m_uRLHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticBeanstalk
}  // namespace Aws
