﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/drs/Drs_EXPORTS.h>
#include <aws/drs/model/LaunchActionCategory.h>
#include <aws/drs/model/LaunchActionParameter.h>
#include <aws/drs/model/LaunchActionType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace drs {
namespace Model {

/**
 * <p>Launch action.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/LaunchAction">AWS
 * API Reference</a></p>
 */
class LaunchAction {
 public:
  AWS_DRS_API LaunchAction() = default;
  AWS_DRS_API LaunchAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_DRS_API LaunchAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DRS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Launch action code.</p>
   */
  inline const Aws::String& GetActionCode() const { return m_actionCode; }
  inline bool ActionCodeHasBeenSet() const { return m_actionCodeHasBeenSet; }
  template <typename ActionCodeT = Aws::String>
  void SetActionCode(ActionCodeT&& value) {
    m_actionCodeHasBeenSet = true;
    m_actionCode = std::forward<ActionCodeT>(value);
  }
  template <typename ActionCodeT = Aws::String>
  LaunchAction& WithActionCode(ActionCodeT&& value) {
    SetActionCode(std::forward<ActionCodeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetActionId() const { return m_actionId; }
  inline bool ActionIdHasBeenSet() const { return m_actionIdHasBeenSet; }
  template <typename ActionIdT = Aws::String>
  void SetActionId(ActionIdT&& value) {
    m_actionIdHasBeenSet = true;
    m_actionId = std::forward<ActionIdT>(value);
  }
  template <typename ActionIdT = Aws::String>
  LaunchAction& WithActionId(ActionIdT&& value) {
    SetActionId(std::forward<ActionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetActionVersion() const { return m_actionVersion; }
  inline bool ActionVersionHasBeenSet() const { return m_actionVersionHasBeenSet; }
  template <typename ActionVersionT = Aws::String>
  void SetActionVersion(ActionVersionT&& value) {
    m_actionVersionHasBeenSet = true;
    m_actionVersion = std::forward<ActionVersionT>(value);
  }
  template <typename ActionVersionT = Aws::String>
  LaunchAction& WithActionVersion(ActionVersionT&& value) {
    SetActionVersion(std::forward<ActionVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the launch action is active.</p>
   */
  inline bool GetActive() const { return m_active; }
  inline bool ActiveHasBeenSet() const { return m_activeHasBeenSet; }
  inline void SetActive(bool value) {
    m_activeHasBeenSet = true;
    m_active = value;
  }
  inline LaunchAction& WithActive(bool value) {
    SetActive(value);
    return *this;
  }
  ///@}

  ///@{

  inline LaunchActionCategory GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  inline void SetCategory(LaunchActionCategory value) {
    m_categoryHasBeenSet = true;
    m_category = value;
  }
  inline LaunchAction& WithCategory(LaunchActionCategory value) {
    SetCategory(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  LaunchAction& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  LaunchAction& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the launch will not be marked as failed if this action fails.</p>
   */
  inline bool GetOptional() const { return m_optional; }
  inline bool OptionalHasBeenSet() const { return m_optionalHasBeenSet; }
  inline void SetOptional(bool value) {
    m_optionalHasBeenSet = true;
    m_optional = value;
  }
  inline LaunchAction& WithOptional(bool value) {
    SetOptional(value);
    return *this;
  }
  ///@}

  ///@{

  inline int GetOrder() const { return m_order; }
  inline bool OrderHasBeenSet() const { return m_orderHasBeenSet; }
  inline void SetOrder(int value) {
    m_orderHasBeenSet = true;
    m_order = value;
  }
  inline LaunchAction& WithOrder(int value) {
    SetOrder(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Aws::String, LaunchActionParameter>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Map<Aws::String, LaunchActionParameter>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, LaunchActionParameter>>
  LaunchAction& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = LaunchActionParameter>
  LaunchAction& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Launch action type.</p>
   */
  inline LaunchActionType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(LaunchActionType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline LaunchAction& WithType(LaunchActionType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_actionCode;

  Aws::String m_actionId;

  Aws::String m_actionVersion;

  bool m_active{false};

  LaunchActionCategory m_category{LaunchActionCategory::NOT_SET};

  Aws::String m_description;

  Aws::String m_name;

  bool m_optional{false};

  int m_order{0};

  Aws::Map<Aws::String, LaunchActionParameter> m_parameters;

  LaunchActionType m_type{LaunchActionType::NOT_SET};
  bool m_actionCodeHasBeenSet = false;
  bool m_actionIdHasBeenSet = false;
  bool m_actionVersionHasBeenSet = false;
  bool m_activeHasBeenSet = false;
  bool m_categoryHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_optionalHasBeenSet = false;
  bool m_orderHasBeenSet = false;
  bool m_parametersHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace drs
}  // namespace Aws
