﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehend/Comprehend_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Comprehend {
namespace Model {
class CreateDocumentClassifierResult {
 public:
  AWS_COMPREHEND_API CreateDocumentClassifierResult() = default;
  AWS_COMPREHEND_API CreateDocumentClassifierResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COMPREHEND_API CreateDocumentClassifierResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies the document classifier.</p>
   */
  inline const Aws::String& GetDocumentClassifierArn() const { return m_documentClassifierArn; }
  template <typename DocumentClassifierArnT = Aws::String>
  void SetDocumentClassifierArn(DocumentClassifierArnT&& value) {
    m_documentClassifierArnHasBeenSet = true;
    m_documentClassifierArn = std::forward<DocumentClassifierArnT>(value);
  }
  template <typename DocumentClassifierArnT = Aws::String>
  CreateDocumentClassifierResult& WithDocumentClassifierArn(DocumentClassifierArnT&& value) {
    SetDocumentClassifierArn(std::forward<DocumentClassifierArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDocumentClassifierResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_documentClassifierArn;

  Aws::String m_requestId;
  bool m_documentClassifierArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Comprehend
}  // namespace Aws
