﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/codebuild/model/TestCase.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class DescribeTestCasesResult {
 public:
  AWS_CODEBUILD_API DescribeTestCasesResult() = default;
  AWS_CODEBUILD_API DescribeTestCasesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API DescribeTestCasesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> During a previous call, the maximum number of items that can be returned is
   * the value specified in <code>maxResults</code>. If there more items in the list,
   * then a unique string called a <i>nextToken</i> is returned. To get the next
   * batch of items in the list, call this operation again, adding the next token to
   * the call. To get all of the items in the list, keep calling this operation with
   * each subsequent next token that is returned, until no more next tokens are
   * returned. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeTestCasesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The returned list of test cases. </p>
   */
  inline const Aws::Vector<TestCase>& GetTestCases() const { return m_testCases; }
  template <typename TestCasesT = Aws::Vector<TestCase>>
  void SetTestCases(TestCasesT&& value) {
    m_testCasesHasBeenSet = true;
    m_testCases = std::forward<TestCasesT>(value);
  }
  template <typename TestCasesT = Aws::Vector<TestCase>>
  DescribeTestCasesResult& WithTestCases(TestCasesT&& value) {
    SetTestCases(std::forward<TestCasesT>(value));
    return *this;
  }
  template <typename TestCasesT = TestCase>
  DescribeTestCasesResult& AddTestCases(TestCasesT&& value) {
    m_testCasesHasBeenSet = true;
    m_testCases.emplace_back(std::forward<TestCasesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeTestCasesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<TestCase> m_testCases;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_testCasesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
