﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKIdentity {
namespace Model {
class UpdateAppInstanceUserEndpointResult {
 public:
  AWS_CHIMESDKIDENTITY_API UpdateAppInstanceUserEndpointResult() = default;
  AWS_CHIMESDKIDENTITY_API UpdateAppInstanceUserEndpointResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CHIMESDKIDENTITY_API UpdateAppInstanceUserEndpointResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::String& GetAppInstanceUserArn() const { return m_appInstanceUserArn; }
  template <typename AppInstanceUserArnT = Aws::String>
  void SetAppInstanceUserArn(AppInstanceUserArnT&& value) {
    m_appInstanceUserArnHasBeenSet = true;
    m_appInstanceUserArn = std::forward<AppInstanceUserArnT>(value);
  }
  template <typename AppInstanceUserArnT = Aws::String>
  UpdateAppInstanceUserEndpointResult& WithAppInstanceUserArn(AppInstanceUserArnT&& value) {
    SetAppInstanceUserArn(std::forward<AppInstanceUserArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the <code>AppInstanceUserEndpoint</code>.</p>
   */
  inline const Aws::String& GetEndpointId() const { return m_endpointId; }
  template <typename EndpointIdT = Aws::String>
  void SetEndpointId(EndpointIdT&& value) {
    m_endpointIdHasBeenSet = true;
    m_endpointId = std::forward<EndpointIdT>(value);
  }
  template <typename EndpointIdT = Aws::String>
  UpdateAppInstanceUserEndpointResult& WithEndpointId(EndpointIdT&& value) {
    SetEndpointId(std::forward<EndpointIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateAppInstanceUserEndpointResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceUserArn;

  Aws::String m_endpointId;

  Aws::String m_requestId;
  bool m_appInstanceUserArnHasBeenSet = false;
  bool m_endpointIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
