﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/auditmanager/AuditManager_EXPORTS.h>
#include <aws/auditmanager/model/Assessment.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace AuditManager {
namespace Model {
class UpdateAssessmentStatusResult {
 public:
  AWS_AUDITMANAGER_API UpdateAssessmentStatusResult() = default;
  AWS_AUDITMANAGER_API UpdateAssessmentStatusResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_AUDITMANAGER_API UpdateAssessmentStatusResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The name of the updated assessment that the
   * <code>UpdateAssessmentStatus</code> API returned. </p>
   */
  inline const Assessment& GetAssessment() const { return m_assessment; }
  template <typename AssessmentT = Assessment>
  void SetAssessment(AssessmentT&& value) {
    m_assessmentHasBeenSet = true;
    m_assessment = std::forward<AssessmentT>(value);
  }
  template <typename AssessmentT = Assessment>
  UpdateAssessmentStatusResult& WithAssessment(AssessmentT&& value) {
    SetAssessment(std::forward<AssessmentT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateAssessmentStatusResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Assessment m_assessment;

  Aws::String m_requestId;
  bool m_assessmentHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AuditManager
}  // namespace Aws
