﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appintegrations/AppIntegrationsService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppIntegrationsService {
namespace Model {

/**
 * <p>The configuration for what files should be pulled from the
 * source.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/FileConfiguration">AWS
 * API Reference</a></p>
 */
class FileConfiguration {
 public:
  AWS_APPINTEGRATIONSSERVICE_API FileConfiguration() = default;
  AWS_APPINTEGRATIONSSERVICE_API FileConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPINTEGRATIONSSERVICE_API FileConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPINTEGRATIONSSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Identifiers for the source folders to pull all files from recursively.</p>
   */
  inline const Aws::Vector<Aws::String>& GetFolders() const { return m_folders; }
  inline bool FoldersHasBeenSet() const { return m_foldersHasBeenSet; }
  template <typename FoldersT = Aws::Vector<Aws::String>>
  void SetFolders(FoldersT&& value) {
    m_foldersHasBeenSet = true;
    m_folders = std::forward<FoldersT>(value);
  }
  template <typename FoldersT = Aws::Vector<Aws::String>>
  FileConfiguration& WithFolders(FoldersT&& value) {
    SetFolders(std::forward<FoldersT>(value));
    return *this;
  }
  template <typename FoldersT = Aws::String>
  FileConfiguration& AddFolders(FoldersT&& value) {
    m_foldersHasBeenSet = true;
    m_folders.emplace_back(std::forward<FoldersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Restrictions for what files should be pulled from the source.</p>
   */
  inline const Aws::Map<Aws::String, Aws::Vector<Aws::String>>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Map<Aws::String, Aws::Vector<Aws::String>>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Map<Aws::String, Aws::Vector<Aws::String>>>
  FileConfiguration& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersKeyT = Aws::String, typename FiltersValueT = Aws::Vector<Aws::String>>
  FileConfiguration& AddFilters(FiltersKeyT&& key, FiltersValueT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace(std::forward<FiltersKeyT>(key), std::forward<FiltersValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_folders;

  Aws::Map<Aws::String, Aws::Vector<Aws::String>> m_filters;
  bool m_foldersHasBeenSet = false;
  bool m_filtersHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppIntegrationsService
}  // namespace Aws
