﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGatewayRequest.h>
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace APIGateway {
namespace Model {

/**
 * <p>Creates a new documentation version of a given API.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/CreateDocumentationVersionRequest">AWS
 * API Reference</a></p>
 */
class CreateDocumentationVersionRequest : public APIGatewayRequest {
 public:
  AWS_APIGATEWAY_API CreateDocumentationVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateDocumentationVersion"; }

  AWS_APIGATEWAY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The string identifier of the associated RestApi.</p>
   */
  inline const Aws::String& GetRestApiId() const { return m_restApiId; }
  inline bool RestApiIdHasBeenSet() const { return m_restApiIdHasBeenSet; }
  template <typename RestApiIdT = Aws::String>
  void SetRestApiId(RestApiIdT&& value) {
    m_restApiIdHasBeenSet = true;
    m_restApiId = std::forward<RestApiIdT>(value);
  }
  template <typename RestApiIdT = Aws::String>
  CreateDocumentationVersionRequest& WithRestApiId(RestApiIdT&& value) {
    SetRestApiId(std::forward<RestApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version identifier of the new snapshot.</p>
   */
  inline const Aws::String& GetDocumentationVersion() const { return m_documentationVersion; }
  inline bool DocumentationVersionHasBeenSet() const { return m_documentationVersionHasBeenSet; }
  template <typename DocumentationVersionT = Aws::String>
  void SetDocumentationVersion(DocumentationVersionT&& value) {
    m_documentationVersionHasBeenSet = true;
    m_documentationVersion = std::forward<DocumentationVersionT>(value);
  }
  template <typename DocumentationVersionT = Aws::String>
  CreateDocumentationVersionRequest& WithDocumentationVersion(DocumentationVersionT&& value) {
    SetDocumentationVersion(std::forward<DocumentationVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The stage name to be associated with the new documentation snapshot.</p>
   */
  inline const Aws::String& GetStageName() const { return m_stageName; }
  inline bool StageNameHasBeenSet() const { return m_stageNameHasBeenSet; }
  template <typename StageNameT = Aws::String>
  void SetStageName(StageNameT&& value) {
    m_stageNameHasBeenSet = true;
    m_stageName = std::forward<StageNameT>(value);
  }
  template <typename StageNameT = Aws::String>
  CreateDocumentationVersionRequest& WithStageName(StageNameT&& value) {
    SetStageName(std::forward<StageNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description about the new documentation snapshot.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateDocumentationVersionRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_restApiId;

  Aws::String m_documentationVersion;

  Aws::String m_stageName;

  Aws::String m_description;
  bool m_restApiIdHasBeenSet = false;
  bool m_documentationVersionHasBeenSet = false;
  bool m_stageNameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
