﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amp/PrometheusServiceRequest.h>
#include <aws/amp/PrometheusService_EXPORTS.h>
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace PrometheusService {
namespace Model {

/**
 * <p>Represents the input of a <code>DeleteScraper</code> operation.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteScraperRequest">AWS
 * API Reference</a></p>
 */
class DeleteScraperRequest : public PrometheusServiceRequest {
 public:
  AWS_PROMETHEUSSERVICE_API DeleteScraperRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteScraper"; }

  AWS_PROMETHEUSSERVICE_API Aws::String SerializePayload() const override;

  AWS_PROMETHEUSSERVICE_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The ID of the scraper to delete.</p>
   */
  inline const Aws::String& GetScraperId() const { return m_scraperId; }
  inline bool ScraperIdHasBeenSet() const { return m_scraperIdHasBeenSet; }
  template <typename ScraperIdT = Aws::String>
  void SetScraperId(ScraperIdT&& value) {
    m_scraperIdHasBeenSet = true;
    m_scraperId = std::forward<ScraperIdT>(value);
  }
  template <typename ScraperIdT = Aws::String>
  DeleteScraperRequest& WithScraperId(ScraperIdT&& value) {
    SetScraperId(std::forward<ScraperIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>(Optional) A unique, case-sensitive identifier that you can provide to ensure
   * the idempotency of the request.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  DeleteScraperRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scraperId;

  Aws::String m_clientToken{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_scraperIdHasBeenSet = false;
  bool m_clientTokenHasBeenSet = true;
};

}  // namespace Model
}  // namespace PrometheusService
}  // namespace Aws
