/*
 * Decompiled with CFR 0.152.
 */
package hughai.basictypes;

import com.springrts.ai.oo.AIFloat3;
import org.w3c.dom.Element;

public class Float3 {
    public float x;
    public float y;
    public float z;

    public Float3() {
    }

    public Float3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Float3(AIFloat3 aIFloat3) {
        this.x = aIFloat3.x;
        this.y = aIFloat3.y;
        this.z = aIFloat3.z;
    }

    public static Float3 fromAIFloat3(AIFloat3 aIFloat3) {
        return new Float3(aIFloat3);
    }

    public float[] ToDoubleArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public AIFloat3 toAIFloat3() {
        return new AIFloat3(this.x, this.y, this.z);
    }

    public Float3 add(Float3 float3) {
        return new Float3(this.x + float3.x, this.y + float3.y, this.z + float3.z);
    }

    public Float3 subtract(Float3 float3) {
        return new Float3(this.x - float3.x, this.y - float3.y, this.z - float3.z);
    }

    public Float3 multiply(float f) {
        return new Float3(this.x * f, this.y * f, this.z * f);
    }

    public Float3 divide(float f) {
        return new Float3(this.x / f, this.y / f, this.z / f);
    }

    public void Normalize() {
        float f = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if ((double)f > 1.0E-5) {
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }
    }

    public Float3 Cross(Float3 float3) {
        return new Float3(this.y * float3.z - this.z * float3.y, this.z * float3.x - this.x * float3.z, this.x * float3.y - this.y * float3.x);
    }

    public float GetSquaredDistance(Float3 float3) {
        return (float3.x - this.x) * (float3.x - this.x) + (float3.y - this.y) * (float3.y - this.y) + (float3.z - this.z) * (float3.z - this.z);
    }

    public void writeToXmlElement(Element element) {
        element.setAttribute("x", "" + this.x);
        element.setAttribute("y", "" + this.y);
        element.setAttribute("z", "" + this.z);
    }

    public void readFromXmlElement(Element element) {
        this.x = Float.parseFloat(element.getAttribute("x"));
        this.y = Float.parseFloat(element.getAttribute("y"));
        this.z = Float.parseFloat(element.getAttribute("z"));
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Float3 float3 = (Float3)object;
        if ((double)Math.abs(this.x - float3.x) > 0.001) {
            return false;
        }
        if ((double)Math.abs(this.y - float3.y) > 0.001) {
            return false;
        }
        return !((double)Math.abs(this.z - float3.z) > 0.001);
    }
}

