# flake8: noqa
import sys
import warnings

from pydantic.v1 import dataclasses
from pydantic.v1.annotated_types import create_model_from_namedtuple, create_model_from_typeddict
from pydantic.v1.class_validators import root_validator, validator
from pydantic.v1.config import BaseConfig, ConfigDict, Extra
from pydantic.v1.decorator import validate_arguments
from pydantic.v1.env_settings import BaseSettings
from pydantic.v1.error_wrappers import ValidationError
from pydantic.v1.errors import *
from pydantic.v1.fields import Field, PrivateAttr, Required
from pydantic.v1.main import *
from pydantic.v1.networks import *
from pydantic.v1.parse import Protocol
from pydantic.v1.tools import *
from pydantic.v1.types import *
from pydantic.v1.version import VERSION, compiled

__version__ = VERSION

# WARNING __all__ from pydantic.errors is not included here, it will be removed as an export here in v2
# please use "from pydantic.v1.errors import ..." instead
__all__ = [
    # annotated types utils
    'create_model_from_namedtuple',
    'create_model_from_typeddict',
    # dataclasses
    'dataclasses',
    # class_validators
    'root_validator',
    'validator',
    # config
    'BaseConfig',
    'ConfigDict',
    'Extra',
    # decorator
    'validate_arguments',
    # env_settings
    'BaseSettings',
    # error_wrappers
    'ValidationError',
    # fields
    'Field',
    'Required',
    # main
    'BaseModel',
    'create_model',
    'validate_model',
    # network
    'AnyUrl',
    'AnyHttpUrl',
    'FileUrl',
    'HttpUrl',
    'stricturl',
    'EmailStr',
    'NameEmail',
    'IPvAnyAddress',
    'IPvAnyInterface',
    'IPvAnyNetwork',
    'PostgresDsn',
    'CockroachDsn',
    'AmqpDsn',
    'RedisDsn',
    'MongoDsn',
    'KafkaDsn',
    'validate_email',
    # parse
    'Protocol',
    # tools
    'parse_file_as',
    'parse_obj_as',
    'parse_raw_as',
    'schema_of',
    'schema_json_of',
    # types
    'NoneStr',
    'NoneBytes',
    'StrBytes',
    'NoneStrBytes',
    'StrictStr',
    'ConstrainedBytes',
    'conbytes',
    'ConstrainedList',
    'conlist',
    'ConstrainedSet',
    'conset',
    'ConstrainedFrozenSet',
    'confrozenset',
    'ConstrainedStr',
    'constr',
    'PyObject',
    'ConstrainedInt',
    'conint',
    'PositiveInt',
    'NegativeInt',
    'NonNegativeInt',
    'NonPositiveInt',
    'ConstrainedFloat',
    'confloat',
    'PositiveFloat',
    'NegativeFloat',
    'NonNegativeFloat',
    'NonPositiveFloat',
    'FiniteFloat',
    'ConstrainedDecimal',
    'condecimal',
    'ConstrainedDate',
    'condate',
    'UUID1',
    'UUID3',
    'UUID4',
    'UUID5',
    'FilePath',
    'DirectoryPath',
    'Json',
    'JsonWrapper',
    'SecretField',
    'SecretStr',
    'SecretBytes',
    'StrictBool',
    'StrictBytes',
    'StrictInt',
    'StrictFloat',
    'PaymentCardNumber',
    'PrivateAttr',
    'ByteSize',
    'PastDate',
    'FutureDate',
    # version
    'compiled',
    'VERSION',
]


if sys.version_info >= (3, 14):
    warnings.warn(
        "Core Pydantic V1 functionality isn't compatible with Python 3.14 or greater.",
        UserWarning,
        stacklevel=2,
    )
