/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.renderer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatImpl;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class OWLXMLObjectRenderer
implements OWLObjectVisitor {
    private final OWLXMLWriter writer;
    private OWLDocumentFormat format;
    private boolean explicitXsdString = false;

    public OWLXMLObjectRenderer(@Nonnull OWLXMLWriter writer) {
        this(writer, null);
    }

    public OWLXMLObjectRenderer(@Nonnull OWLXMLWriter writer, OWLDocumentFormat format) {
        this.writer = OWLAPIPreconditions.checkNotNull(writer, "writer cannot be null");
        this.format = format;
    }

    private void writeAnnotations(@Nonnull OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        for (OWLAnnotation anno : CollectionFactory.sortOptionally(axiom.getAnnotations())) {
            anno.accept(this);
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        ontology.getImportsDeclarations().stream().sorted().forEach(decl -> {
            this.writer.writeStartElement(OWLXMLVocabulary.IMPORT);
            this.writer.writeTextContent(decl.getIRI().toString());
            this.writer.writeEndElement();
        });
        for (OWLAnnotation annotation : CollectionFactory.sortOptionally(ontology.getAnnotations())) {
            annotation.accept(this);
        }
        ArrayList<OWLDeclarationAxiom> declarations = new ArrayList<OWLDeclarationAxiom>(ontology.getAxioms(AxiomType.DECLARATION));
        declarations.sort(null);
        HashSet<OWLEntity> declared = new HashSet<OWLEntity>(ontology.getSignature());
        for (OWLDeclarationAxiom ax : declarations) {
            ax.accept(this);
            declared.remove(ax.getEntity());
        }
        if (!declared.isEmpty()) {
            boolean addMissing = true;
            if (this.format == null) {
                this.format = ontology.getOWLOntologyManager().getOntologyFormat(ontology);
            }
            if (this.format != null) {
                addMissing = this.format.isAddMissingTypes();
                this.explicitXsdString = (Boolean)this.format.getParameter((Serializable)((Object)"force xsd:string on literals"), Boolean.FALSE);
            }
            if (addMissing) {
                Collection<IRI> illegalPunnings = OWLDocumentFormatImpl.determineIllegalPunnings(addMissing, ontology.getSignature(), ontology.getPunnedIRIs(Imports.INCLUDED));
                for (OWLEntity e : declared) {
                    if (e.isBuiltIn() || illegalPunnings.contains(e.getIRI()) || ontology.isDeclared(e, Imports.INCLUDED)) continue;
                    ontology.getOWLOntologyManager().getOWLDataFactory().getOWLDeclarationAxiom(e).accept(this);
                }
            }
        }
        ArrayList axioms = new ArrayList();
        for (AxiomType<?> t : AxiomType.AXIOM_TYPES) {
            if (t.equals(AxiomType.DECLARATION)) continue;
            axioms.addAll(ontology.getAxioms(t));
        }
        for (OWLAxiom ax : CollectionFactory.sortOptionally(axioms)) {
            ax.accept(this);
        }
    }

    @Override
    public void visit(IRI iri) {
        OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null");
        this.writer.writeIRIElement(iri);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANONYMOUS_INDIVIDUAL);
        this.writer.writeNodeIDAttribute(individual.getID());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ASYMMETRIC_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ASSERTION);
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        axiom.getIndividual().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_ASSERTION);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_DOMAIN);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getDomain().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_RANGE);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_DATA_PROPERTY_OF);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DECLARATION);
        this.writeAnnotations(axiom);
        axiom.getEntity().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS);
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_CLASSES);
        this.writeAnnotations(axiom);
        this.render(axiom.getClassExpressions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_DATA_PROPERTIES);
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_OBJECT_PROPERTIES);
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DISJOINT_UNION);
        this.writeAnnotations(axiom);
        axiom.getOWLClass().accept(this);
        this.render(axiom.getClassExpressions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_ASSERTION);
        this.writeAnnotations(axiom);
        axiom.getProperty().accept(this);
        axiom.getSubject().accept(this);
        axiom.getValue().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_CLASSES);
        this.writeAnnotations(axiom);
        this.render(axiom.getClassExpressions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_DATA_PROPERTIES);
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES);
        this.writeAnnotations(axiom);
        this.render(axiom.getProperties());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_DATA_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.FUNCTIONAL_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.INVERSE_OBJECT_PROPERTIES);
        this.writeAnnotations(axiom);
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.IRREFLEXIVE_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_DATA_PROPERTY_ASSERTION);
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.NEGATIVE_OBJECT_PROPERTY_ASSERTION);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getSubject().accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF);
        this.writeAnnotations(axiom);
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_CHAIN);
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        this.writer.writeEndElement();
        axiom.getSuperProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_DOMAIN);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        axiom.getDomain().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_RANGE);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.REFLEXIVE_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SAME_INDIVIDUAL);
        this.writeAnnotations(axiom);
        this.render(axiom.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_CLASS_OF);
        this.writeAnnotations(axiom);
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SYMMETRIC_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.TRANSITIVE_OBJECT_PROPERTY);
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLClass ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS);
        this.writer.writeIRIAttribute(ce.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ALL_VALUES_FROM);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_EXACT_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MAX_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_MIN_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLDataRange)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_SOME_VALUES_FROM);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_HAS_VALUE);
        ce.getProperty().accept(this);
        ((OWLLiteral)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ALL_VALUES_FROM);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_COMPLEMENT_OF);
        ce.getOperand().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_EXACT_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_INTERSECTION_OF);
        this.render(ce.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MAX_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_MIN_CARDINALITY);
        this.writer.writeCardinalityAttribute(ce.getCardinality());
        ce.getProperty().accept(this);
        if (ce.isQualified()) {
            ((OWLClassExpression)ce.getFiller()).accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_ONE_OF);
        this.render(ce.getIndividuals());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_HAS_SELF);
        ce.getProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_SOME_VALUES_FROM);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_UNION_OF);
        this.render(ce.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_HAS_VALUE);
        ce.getProperty().accept(this);
        ((OWLIndividual)ce.getFiller()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_COMPLEMENT_OF);
        node.getDataRange().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_ONE_OF);
        this.render(node.getValues());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDatatype node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE);
        this.writer.writeIRIAttribute(node.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_RESTRICTION);
        node.getDatatype().accept(this);
        this.render(node.getFacetRestrictions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.writer.writeStartElement(OWLXMLVocabulary.FACET_RESTRICTION);
        this.writer.writeFacetAttribute(node.getFacet());
        node.getFacetValue().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLLiteral node) {
        this.writer.writeStartElement(OWLXMLVocabulary.LITERAL);
        if (node.hasLang()) {
            this.writer.writeLangAttribute(node.getLang());
        } else if (!(node.isRDFPlainLiteral() || !this.explicitXsdString && OWL2Datatype.XSD_STRING.getIRI().equals(node.getDatatype().getIRI()))) {
            this.writer.writeDatatypeAttribute(node.getDatatype());
        }
        this.writer.writeTextContent(node.getLiteral());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_INVERSE_OF);
        property.getInverse().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.NAMED_INDIVIDUAL);
        this.writer.writeIRIAttribute(individual.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.HAS_KEY);
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        this.render(axiom.getObjectPropertyExpressions());
        this.render(axiom.getDataPropertyExpressions());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_INTERSECTION_OF);
        this.render(node.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_UNION_OF);
        this.render(node.getOperands());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY);
        this.writer.writeIRIAttribute(property.getIRI());
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION);
        for (OWLAnnotation anno : CollectionFactory.sortOptionally(node.getAnnotations())) {
            anno.accept(this);
        }
        node.getProperty().accept(this);
        node.getValue().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY_DOMAIN);
        this.writeAnnotations(axiom);
        axiom.getProperty().accept(this);
        axiom.getDomain().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.ANNOTATION_PROPERTY_RANGE);
        this.writeAnnotations(axiom);
        axiom.getProperty().accept(this);
        axiom.getRange().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_ANNOTATION_PROPERTY_OF);
        this.writeAnnotations(axiom);
        axiom.getSubProperty().accept(this);
        axiom.getSuperProperty().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATATYPE_DEFINITION);
        this.writeAnnotations(axiom);
        axiom.getDatatype().accept(this);
        axiom.getDataRange().accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLRule rule) {
        this.writer.writeStartElement(OWLXMLVocabulary.DL_SAFE_RULE);
        this.writeAnnotations(rule);
        this.writer.writeStartElement(OWLXMLVocabulary.BODY);
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement(OWLXMLVocabulary.HEAD);
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ATOM);
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_RANGE_ATOM);
        node.getPredicate().accept(this);
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ATOM);
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DATA_PROPERTY_ATOM);
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.BUILT_IN_ATOM);
        this.writer.writeIRIAttribute(node.getPredicate());
        for (SWRLDArgument arg : node.getArguments()) {
            arg.accept(this);
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLVariable node) {
        this.writer.writeStartElement(OWLXMLVocabulary.VARIABLE);
        if ("urn:swrl:var#".equals(node.getIRI().getNamespace()) || "urn:swrl#".equals(node.getIRI().getNamespace())) {
            this.writer.writeIRIAttribute(IRI.create("urn:swrl:var#", node.getIRI().getFragment()));
        } else {
            this.writer.writeIRIAttribute(node.getIRI());
        }
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.DIFFERENT_INDIVIDUALS_ATOM);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writer.writeEndElement();
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.writer.writeStartElement(OWLXMLVocabulary.SAME_INDIVIDUAL_ATOM);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.writer.writeEndElement();
    }

    private void render(Set<? extends OWLObject> objects) {
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(this);
        }
    }
}

