/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.lang;

import java.awt.BorderLayout;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodeRegistry;
import org.protege.editor.owl.ui.lang.LangCodeRenderer;
import org.protege.editor.owl.ui.util.SuggestField;

public class LangTagEditor
extends JComponent {
    private static final String PLACEHOLDER_TEXT = "Language Tag";
    private final LangCodeRegistry registry;
    private final SuggestField<LangCode> suggestField;

    public LangTagEditor(LangCodeRegistry registry) {
        this.registry = registry;
        this.suggestField = new SuggestField(PLACEHOLDER_TEXT);
        this.setLayout(new BorderLayout());
        this.add(this.suggestField, "North");
        this.suggestField.setSuggestOracle(this::getLangCodesMatching);
        this.suggestField.setSuggestionToString(LangCode::getLangCode);
        this.suggestField.setRenderer(new LangCodeRenderer());
    }

    private Stream<LangCode> getLangCodesMatching(@Nonnull String query) {
        return this.registry.getLangCodes().stream().filter(lc -> LangTagEditor.matches(query, lc));
    }

    private static boolean matches(String enteredText, LangCode lc) {
        Pattern pattern = Pattern.compile(String.format("^.*\\b%s.*$", Pattern.quote(enteredText)), 2);
        Matcher matcher = pattern.matcher(lc.getLangCode() + " " + lc.getDescription());
        return matcher.find();
    }

    @Nonnull
    public Optional<LangCode> getLangCode() {
        return this.registry.getLangCode(this.suggestField.getText().trim().toLowerCase());
    }

    public void setLangCode(@Nonnull LangCode langCode) {
        this.suggestField.setText(langCode.getLangCode());
    }

    public void clear() {
        this.suggestField.clear();
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.suggestField.setChangeListener(changeListener);
    }
}

