/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.inference;

import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.owl.ui.inference.PrecomputePreferencesPanel;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class PrecomputePreferencesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3237338845911865353L;
    private Set<InferenceType> required;
    private Set<InferenceType> disallowed;

    public PrecomputePreferencesTableModel(Set<InferenceType> required, Set<InferenceType> disallowed) {
        this.required = required;
        this.disallowed = disallowed;
    }

    @Override
    public int getRowCount() {
        return InferenceType.values().length;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Column column = Column.values()[columnIndex];
        switch (column.ordinal()) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return Boolean.class;
            }
        }
        throw new UnsupportedOperationException("Programmer Error: missed a case");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Column column = Column.values()[columnIndex];
        switch (column.ordinal()) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        throw new UnsupportedOperationException("Programmer Error: missed a case");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InferenceType type = InferenceType.values()[rowIndex];
        Column column = Column.values()[columnIndex];
        switch (column.ordinal()) {
            case 0: {
                return PrecomputePreferencesPanel.getInferenceTypeName(type);
            }
            case 1: {
                return this.required.contains(type);
            }
            case 2: {
                return this.disallowed.contains(type);
            }
        }
        throw new UnsupportedOperationException("Programmer Error: missed a case");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Boolean v = (Boolean)aValue;
        InferenceType type = InferenceType.values()[rowIndex];
        Column column = Column.values()[columnIndex];
        switch (column.ordinal()) {
            case 1: {
                this.setRequired(type, v);
                if (!v.booleanValue()) break;
                this.setDisallowed(type, v == false);
                break;
            }
            case 2: {
                this.setDisallowed(type, v);
                if (!v.booleanValue()) break;
                this.setRequired(type, v == false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Programmer Error: shouldn't happen");
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    private void setRequired(InferenceType type, boolean v) {
        if (v) {
            this.required.add(type);
        } else {
            this.required.remove(type);
        }
    }

    private void setDisallowed(InferenceType type, boolean v) {
        if (v) {
            this.disallowed.add(type);
        } else {
            this.disallowed.remove(type);
        }
    }

    public static enum Column {
        INFERENCE_TYPE("Inference Type"),
        REQUIRED("Required"),
        DISALLOWED("Disallowed");

        private String columnName;

        private Column(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }
}

