/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.breadcrumb;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.protege.editor.core.util.ClickHandler;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.ui.breadcrumb.Breadcrumb;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailView;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbViewImpl;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.OWLObject;

public class BreadcrumbTrailViewImpl
extends JPanel
implements BreadcrumbTrailView {
    private final OWLWorkspace workspace;
    private ClickHandler<Breadcrumb> breadcrumbClickHandler = value -> {};

    public BreadcrumbTrailViewImpl(@Nonnull OWLWorkspace workspace) {
        this.workspace = (OWLWorkspace)Preconditions.checkNotNull((Object)workspace);
        this.setLayout(new BreadcrumbTrailLayout());
    }

    @Override
    public void setBreadcrumbClickedHandler(@Nonnull ClickHandler<Breadcrumb> clickedHandler) {
        this.breadcrumbClickHandler = (ClickHandler)Preconditions.checkNotNull(clickedHandler);
    }

    @Override
    public void setDisplayedBreadcrumbTrail(@Nonnull List<Breadcrumb> path) {
        this.removeAll();
        if (path.isEmpty()) {
            this.validate();
            this.repaint();
            return;
        }
        OWLObject firstBreadcrumb = path.get(0).getObject();
        int skip = firstBreadcrumb.isTopEntity() ? 1 : 0;
        path.stream().skip(skip).map(breadcrumb -> {
            String rendering = this.workspace.getOWLModelManager().getRendering(breadcrumb.getObject());
            String displayText = BreadcrumbTrailViewImpl.stripSingleQuotes(rendering);
            BreadcrumbViewImpl breadcrumbView = new BreadcrumbViewImpl(breadcrumb.getObject(), displayText);
            breadcrumbView.setViewClickedHandler(owlObject -> this.breadcrumbClickHandler.handleClicked(breadcrumb));
            return breadcrumbView;
        }).forEach(v -> this.add(v.asJComponent()));
        this.validate();
        this.repaint();
    }

    @Nonnull
    private static String stripSingleQuotes(@Nonnull String rendering) {
        return RenderingEscapeUtils.unescape(rendering);
    }

    @Override
    public void clearDisplayedBreadcrumbTrail() {
        this.removeAll();
        this.repaint();
    }

    @Override
    @Nonnull
    public JComponent asJComponent() {
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private static class BreadcrumbTrailLayout
    implements LayoutManager2 {
        private static final int SPACING = 0;
        private List<Component> components = new ArrayList<Component>();

        private BreadcrumbTrailLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.components.add(comp);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(2000, 20);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.components.add(comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.components.remove(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(1500, 22);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(20, 22);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this.components.isEmpty()) {
                return;
            }
            int prefTotalWidth = 0;
            int totalAvailableSpaceToTrim = 0;
            Iterator<Component> it = this.components.iterator();
            while (it.hasNext()) {
                Component component = it.next();
                Dimension prefSize = component.getPreferredSize();
                prefTotalWidth += prefSize.width;
                if (!it.hasNext()) continue;
                totalAvailableSpaceToTrim += prefSize.width;
                prefTotalWidth += 0;
            }
            int x = 0;
            if (prefTotalWidth > parent.getWidth()) {
                double spaceToTrim = prefTotalWidth - parent.getWidth();
                double percentageToTrim = spaceToTrim / (double)totalAvailableSpaceToTrim;
                Iterator<Component> it2 = this.components.iterator();
                while (it2.hasNext()) {
                    Component component = it2.next();
                    Dimension prefSize = component.getPreferredSize();
                    int componentWidth = it2.hasNext() ? (int)((1.0 - percentageToTrim) * (double)prefSize.width) : prefSize.width;
                    component.setBounds(x, 0, componentWidth, prefSize.height);
                    x = x + 0 + componentWidth;
                }
            } else {
                for (Component component : this.components) {
                    Dimension prefSize = component.getPreferredSize();
                    component.setBounds(x, 0, prefSize.width, prefSize.height);
                    x = x + 0 + prefSize.width;
                }
            }
        }
    }
}

