/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.iot;

public class MqttRequestResponseClientOptions {
    private int maxRequestResponseSubscriptions = 0;
    private int maxStreamingSubscriptions = 0;
    private int operationTimeoutSeconds = 0;

    private MqttRequestResponseClientOptions() {
    }

    private MqttRequestResponseClientOptions(MqttRequestResponseClientOptions options) {
        this.maxRequestResponseSubscriptions = options.maxRequestResponseSubscriptions;
        this.maxStreamingSubscriptions = options.maxStreamingSubscriptions;
        this.operationTimeoutSeconds = options.operationTimeoutSeconds;
    }

    public static MqttRequestResponseClientOptionsBuilder builder() {
        return new MqttRequestResponseClientOptionsBuilder();
    }

    int getMaxRequestResponseSubscriptions() {
        return this.maxRequestResponseSubscriptions;
    }

    int getMaxStreamingSubscriptions() {
        return this.maxStreamingSubscriptions;
    }

    int getOperationTimeoutSeconds() {
        return this.operationTimeoutSeconds;
    }

    public static class MqttRequestResponseClientOptionsBuilder {
        private MqttRequestResponseClientOptions options = new MqttRequestResponseClientOptions();

        private MqttRequestResponseClientOptionsBuilder() {
        }

        public MqttRequestResponseClientOptionsBuilder withMaxRequestResponseSubscriptions(int maxRequestResponseSubscriptions) {
            this.options.maxRequestResponseSubscriptions = maxRequestResponseSubscriptions;
            return this;
        }

        public MqttRequestResponseClientOptionsBuilder withMaxStreamingSubscriptions(int maxStreamingSubscriptions) {
            this.options.maxStreamingSubscriptions = maxStreamingSubscriptions;
            return this;
        }

        public MqttRequestResponseClientOptionsBuilder withOperationTimeoutSeconds(int operationTimeoutSeconds) {
            this.options.operationTimeoutSeconds = operationTimeoutSeconds;
            return this;
        }

        public MqttRequestResponseClientOptions build() {
            return new MqttRequestResponseClientOptions(this.options);
        }
    }
}

