/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.Http2ClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBase;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamBase;
import software.amazon.awssdk.crt.http.HttpStreamBaseResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandlerNativeAdapter;
import software.amazon.awssdk.crt.http.HttpVersion;

public class HttpClientConnection
extends CrtResource {
    protected HttpClientConnection(long connectionBinding) {
        this.acquireNativeHandle(connectionBinding);
    }

    public HttpStream makeRequest(HttpRequest request, HttpStreamResponseHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed, can't make requests on it.");
        }
        if (this.getVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("HTTP/1 only method called on an HTTP/2 connection.");
        }
        HttpStreamBase stream = HttpClientConnection.httpClientConnectionMakeRequest(this.getNativeHandle(), request.marshalForJni(), request.getBodyStream(), new HttpStreamResponseHandlerNativeAdapter(streamHandler));
        return (HttpStream)stream;
    }

    public HttpStreamBase makeRequest(HttpRequestBase request, HttpStreamBaseResponseHandler streamHandler) throws CrtRuntimeException {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed, can't make requests on it.");
        }
        HttpStreamBase stream = HttpClientConnection.httpClientConnectionMakeRequest(this.getNativeHandle(), request.marshalForJni(), request.getBodyStream(), new HttpStreamResponseHandlerNativeAdapter(streamHandler));
        return stream;
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HttpClientConnection.httpClientConnectionReleaseManaged(this.getNativeHandle());
        }
    }

    public void shutdown() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed and released back to the pool, cannot shutdown the connection.");
        }
        HttpClientConnection.httpClientConnectionShutdown(this.getNativeHandle());
    }

    public boolean isOpen() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed.");
        }
        return HttpClientConnection.httpClientConnectionIsOpen(this.getNativeHandle());
    }

    public HttpVersion getVersion() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnection has been closed.");
        }
        short version = HttpClientConnection.httpClientConnectionGetVersion(this.getNativeHandle());
        return HttpVersion.getEnumValueFromInteger(version);
    }

    private static void onConnectionAcquired(CompletableFuture<HttpClientConnection> acquireFuture, long nativeConnectionBinding, int errorCode) {
        if (errorCode != 0) {
            acquireFuture.completeExceptionally(new HttpException(errorCode));
            return;
        }
        if (HttpVersion.getEnumValueFromInteger(HttpClientConnection.httpClientConnectionGetVersion(nativeConnectionBinding)) == HttpVersion.HTTP_2) {
            Http2ClientConnection h2Conn = new Http2ClientConnection(nativeConnectionBinding);
            if (!acquireFuture.complete(h2Conn)) {
                h2Conn.close();
            }
        } else {
            HttpClientConnection conn = new HttpClientConnection(nativeConnectionBinding);
            if (!acquireFuture.complete(conn)) {
                conn.close();
            }
        }
    }

    public static boolean isErrorRetryable(HttpException exception) {
        return HttpClientConnection.isErrorRetryable(exception.getErrorCode());
    }

    private static native HttpStreamBase httpClientConnectionMakeRequest(long var0, byte[] var2, HttpRequestBodyStream var3, HttpStreamResponseHandlerNativeAdapter var4) throws CrtRuntimeException;

    private static native void httpClientConnectionShutdown(long var0) throws CrtRuntimeException;

    private static native boolean httpClientConnectionIsOpen(long var0) throws CrtRuntimeException;

    private static native void httpClientConnectionReleaseManaged(long var0) throws CrtRuntimeException;

    private static native short httpClientConnectionGetVersion(long var0) throws CrtRuntimeException;

    private static native boolean isErrorRetryable(int var0);
}

