/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.knn.plugin.transport.DeleteModelAction;
import org.opensearch.knn.plugin.transport.DeleteModelRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestDeleteModelHandler
extends BaseRestHandler {
    public static final String NAME = "knn_delete_model_action";

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_knn", "models", "model_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String modelID = request.param("model_id");
        if (!Strings.hasText((String)modelID)) {
            throw new IllegalArgumentException("model ID cannot be empty");
        }
        DeleteModelRequest deleteModelRequest = new DeleteModelRequest(modelID);
        return channel -> client.execute((ActionType)DeleteModelAction.INSTANCE, (ActionRequest)deleteModelRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

