/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class ExtendsValidator
extends AbstractKeywordValidator {
    public ExtendsValidator(JsonNode digest) {
        super("extends");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isObject()) {
            FullData newData = data.withSchema(tree.append(JsonPointer.of(this.keyword, new Object[0])));
            processor.process(report, newData);
            return;
        }
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonPointer pointer = JsonPointer.of(this.keyword, index);
            FullData newData = data.withSchema(tree.append(pointer));
            processor.process(report, newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

