import { Response } from "express";
import Ajv from "ajv";
import { IApiError } from "matrix-appservice-bridge";
export declare const ajv: Ajv;
export interface QueryLinkBody {
    remote_room_channel: string;
    remote_room_server: string;
    key: string | null;
}
export declare const isValidQueryLinkBody: import("ajv").ValidateFunction<QueryLinkBody>;
export interface RequestLinkBody {
    remote_room_channel: string;
    remote_room_server: string;
    matrix_room_id: string;
    op_nick: string;
    key: string | null;
}
export declare const isValidRequestLinkBody: import("ajv").ValidateFunction<RequestLinkBody>;
export interface UnlinkBody {
    remote_room_channel: string;
    remote_room_server: string;
    matrix_room_id: string;
}
export declare const isValidUnlinkBody: import("ajv").ValidateFunction<UnlinkBody>;
export interface ListingsParams {
    roomId: string;
}
export declare const isValidListingsParams: import("ajv").ValidateFunction<ListingsParams>;
export declare enum IrcErrCode {
    UnknownNetwork = "IRC_UNKNOWN_NETWORK",
    UnknownChannel = "IRC_UNKNOWN_CHANNEL",
    UnknownRoom = "IRC_UNKNOWN_ROOM",
    DoubleBridge = "IRC_DOUBLE_BRIDGE",
    ExistingMapping = "IRC_EXISTING_MAPPING",
    ExistingRequest = "IRC_EXISTING_REQUEST",
    NotEnoughPower = "IRC_NOT_ENOUGH_POWER",
    BadOpTarget = "IRC_BAD_OPERATOR_TARGET",
    BridgeAtLimit = "IRC_BRIDGE_AT_LIMIT"
}
export declare class IrcProvisioningError extends Error implements IApiError {
    readonly error: string;
    readonly errcode: IrcErrCode;
    readonly statusCode: number;
    readonly additionalContent: Record<string, unknown>;
    constructor(error: string, errcode: IrcErrCode, statusCode?: number, additionalContent?: Record<string, unknown>);
    get jsonBody(): {
        errcode: string;
        error: string;
    };
    apply(response: Response): void;
}
