/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.oops.InstanceKlass;

public class InterfaceTypeImpl
extends ReferenceTypeImpl
implements InterfaceType {
    private SoftReference superInterfacesCache = null;
    private SoftReference subInterfacesCache = null;
    private SoftReference implementorsCache = null;

    protected InterfaceTypeImpl(VirtualMachine aVm, InstanceKlass aRef) {
        super(aVm, aRef);
    }

    public List superinterfaces() throws ClassNotPreparedException {
        List superinterfaces;
        List list = superinterfaces = this.superInterfacesCache != null ? (List)this.superInterfacesCache.get() : null;
        if (superinterfaces == null) {
            this.checkPrepared();
            superinterfaces = Collections.unmodifiableList(this.getInterfaces());
            this.superInterfacesCache = new SoftReference(superinterfaces);
        }
        return superinterfaces;
    }

    public List subinterfaces() {
        List<InterfaceType> subinterfaces;
        List list = subinterfaces = this.subInterfacesCache != null ? (ArrayList)this.subInterfacesCache.get() : null;
        if (subinterfaces == null) {
            List all = this.vm.allClasses();
            subinterfaces = new ArrayList();
            for (ReferenceType refType : all) {
                InterfaceType interfaze;
                if (!(refType instanceof InterfaceType) || !(interfaze = (InterfaceType)refType).isPrepared() || !interfaze.superinterfaces().contains(this)) continue;
                subinterfaces.add(interfaze);
            }
            subinterfaces = Collections.unmodifiableList(subinterfaces);
            this.subInterfacesCache = new SoftReference(subinterfaces);
        }
        return subinterfaces;
    }

    public List implementors() {
        List<ClassType> implementors;
        List list = implementors = this.implementorsCache != null ? (ArrayList)this.implementorsCache.get() : null;
        if (implementors == null) {
            List all = this.vm.allClasses();
            implementors = new ArrayList();
            for (ReferenceType refType : all) {
                ClassType clazz;
                if (!(refType instanceof ClassType) || !(clazz = (ClassType)refType).isPrepared() || !clazz.interfaces().contains(this)) continue;
                implementors.add(clazz);
            }
            implementors = Collections.unmodifiableList(implementors);
            this.implementorsCache = new SoftReference(implementors);
        }
        return implementors;
    }

    @Override
    void addVisibleMethods(Map methodMap) {
        for (InterfaceTypeImpl interfaze : this.superinterfaces()) {
            interfaze.addVisibleMethods(methodMap);
        }
        this.addToMethodMap(methodMap, this.methods());
    }

    @Override
    List getAllMethods() {
        ArrayList<Method> list = new ArrayList<Method>(this.methods());
        List interfaces = this.allSuperinterfaces();
        for (InterfaceType interfaze : interfaces) {
            list.addAll(interfaze.methods());
        }
        return list;
    }

    List allSuperinterfaces() {
        ArrayList list = new ArrayList();
        this.addSuperinterfaces(list);
        return list;
    }

    void addSuperinterfaces(List list) {
        ArrayList immediate = new ArrayList(this.superinterfaces());
        Iterator iter = immediate.iterator();
        while (iter.hasNext()) {
            InterfaceType interfaze = (InterfaceType)iter.next();
            if (!list.contains(interfaze)) continue;
            iter.remove();
        }
        list.addAll(immediate);
        for (InterfaceType interfaze : immediate) {
            ((InterfaceTypeImpl)interfaze).addSuperinterfaces(list);
        }
    }

    @Override
    boolean isAssignableTo(ReferenceType type) {
        if (this.equals(type)) {
            return true;
        }
        List supers = this.superinterfaces();
        for (InterfaceTypeImpl interfaze : supers) {
            if (!interfaze.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    List inheritedTypes() {
        return this.superinterfaces();
    }

    @Override
    public boolean isInitialized() {
        return this.isPrepared();
    }

    @Override
    public String toString() {
        return "interface " + this.name() + " (" + this.loaderString() + ")";
    }
}

