/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.api;

import org.gephi.project.io.GephiReader;
import org.gephi.project.io.LoadTask;
import org.openide.util.NbBundle;

public class GephiFormatException
extends RuntimeException {
    private Throwable cause;
    private String message;
    private boolean isImport = false;

    public GephiFormatException(Class source, Throwable cause) {
        super(cause);
        this.cause = cause;
        if (source.equals(GephiReader.class) || source.equals(LoadTask.class)) {
            this.isImport = true;
        }
    }

    public GephiFormatException(String message) {
        super(message);
        this.message = message;
    }

    @Override
    public String getMessage() {
        if (this.cause == null) {
            return this.message;
        }
        return this.getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.cause == null) {
            return this.message;
        }
        Object[] params = new Object[4];
        params[0] = this.cause.getClass().getSimpleName();
        params[1] = this.cause.getLocalizedMessage();
        StackTraceElement[] stackTrace = this.cause.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            params[2] = stackTrace[0].getClassName();
            params[3] = stackTrace[0].getLineNumber();
        } else {
            params[2] = "Unknown";
            params[3] = "Unknown";
        }
        if (this.isImport) {
            return String.format(NbBundle.getMessage(GephiFormatException.class, (String)"gephiFormatException_import"), params);
        }
        return String.format(NbBundle.getMessage(GephiFormatException.class, (String)"gephiFormatException_export"), params);
    }
}

