/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.util.logging.Level;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.SelectableAction;

public abstract class SelectableOptionAction
extends SelectableAction {
    public static final String id = "selectableOptionAction";
    private final String optionId;
    protected boolean selected = false;

    protected SelectableOptionAction(FreeColClient freeColClient, String id, String optionId) {
        super(freeColClient, id);
        this.optionId = optionId;
    }

    public final boolean getOption() {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co != null && this.optionId != null) {
            try {
                return co.getBoolean(this.optionId);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failure with option: " + this.optionId, e);
            }
        }
        return false;
    }

    public final void setOption(boolean value) {
        ClientOptions co = this.freeColClient.getClientOptions();
        if (co != null && this.optionId != null) {
            co.setBoolean(this.optionId, value);
        }
    }

    @Override
    protected boolean shouldBeSelected() {
        return this.getOption();
    }
}

