﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/s3control/S3Control_EXPORTS.h>
#include <aws/s3control/model/S3Tag.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace S3Control {
namespace Model {
class GetBucketTaggingResult {
 public:
  AWS_S3CONTROL_API GetBucketTaggingResult() = default;
  AWS_S3CONTROL_API GetBucketTaggingResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_S3CONTROL_API GetBucketTaggingResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The tags set of the Outposts bucket.</p>
   */
  inline const Aws::Vector<S3Tag>& GetTagSet() const { return m_tagSet; }
  template <typename TagSetT = Aws::Vector<S3Tag>>
  void SetTagSet(TagSetT&& value) {
    m_tagSetHasBeenSet = true;
    m_tagSet = std::forward<TagSetT>(value);
  }
  template <typename TagSetT = Aws::Vector<S3Tag>>
  GetBucketTaggingResult& WithTagSet(TagSetT&& value) {
    SetTagSet(std::forward<TagSetT>(value));
    return *this;
  }
  template <typename TagSetT = S3Tag>
  GetBucketTaggingResult& AddTagSet(TagSetT&& value) {
    m_tagSetHasBeenSet = true;
    m_tagSet.emplace_back(std::forward<TagSetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * AWS Request Id value
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetBucketTaggingResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * x-amz-id-2 header value, also known as Host Id
   */
  inline const Aws::String& GetHostId() const { return m_hostId; }
  template <typename HostIdT = Aws::String>
  void SetHostId(HostIdT&& value) {
    m_hostIdHasBeenSet = true;
    m_hostId = std::forward<HostIdT>(value);
  }
  template <typename HostIdT = Aws::String>
  GetBucketTaggingResult& WithHostId(HostIdT&& value) {
    SetHostId(std::forward<HostIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<S3Tag> m_tagSet;

  Aws::String m_requestId;

  Aws::String m_hostId;
  bool m_tagSetHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
  bool m_hostIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3Control
}  // namespace Aws
