﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/VolumeModification.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class ModifyVolumeResponse {
 public:
  AWS_EC2_API ModifyVolumeResponse() = default;
  AWS_EC2_API ModifyVolumeResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API ModifyVolumeResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the volume modification.</p>
   */
  inline const VolumeModification& GetVolumeModification() const { return m_volumeModification; }
  template <typename VolumeModificationT = VolumeModification>
  void SetVolumeModification(VolumeModificationT&& value) {
    m_volumeModificationHasBeenSet = true;
    m_volumeModification = std::forward<VolumeModificationT>(value);
  }
  template <typename VolumeModificationT = VolumeModification>
  ModifyVolumeResponse& WithVolumeModification(VolumeModificationT&& value) {
    SetVolumeModification(std::forward<VolumeModificationT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ModifyVolumeResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  VolumeModification m_volumeModification;

  ResponseMetadata m_responseMetadata;
  bool m_volumeModificationHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
